(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     10435,        398]*)
(*NotebookOutlinePosition[     11338,        428]*)
(*  CellTagsIndexPosition[     11294,        424]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[
"Example: Repeated roots; Diagonalizable"], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "We solve a  5x5  first order differential system having a diagonalizable \
coefficient matrix. The characteristic value problem is solved using ",
  StyleBox["Eigensystem",
    FontWeight->"Bold"],
  " and also manually. A fundamental matrix is manually produced."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[TextData["The coefficient matrix"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(a = {{2, 6, 3, 12, 6}, {0, 26, 6, 54, 6}, {0, 6, 5, 12, 
          6}, {0, \(-12\), \(-3\), \(-25\), \(-3\)}, {0, \(-6\), \(-3\), \
\(-12\), \(-4\)}}\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{2, 6, 3, 12, 6}, {0, 26, 6, 54, 6}, {0, 6, 5, 12, 
        6}, {0, \(-12\), \(-3\), \(-25\), \(-3\)}, {0, \(-6\), \(-3\), \
\(-12\), \(-4\)}}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
  "Solution of the characteristic value problem: \nUsing ",
  StyleBox["Eigensystem",
    FontSize->14]
}], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \({vals, vecs} = Eigensystem[a]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{\(-1\), \(-1\), 2, 2, 
        2}, {{\(-1\), 0, \(-1\), 0, 1}, {0, \(-2\), 0, 1, 0}, {0, 1, \(-6\), 
          0, 2}, {0, \(-5\), 2, 2, 0}, {1, 0, 0, 0, 0}}}\)], "Output"]
}, Closed]],

Cell["The characteristic roots are:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(vals\)], "Input"],

Cell[BoxData[
    \({\(-1\), \(-1\), 2, 2, 2}\)], "Output"]
}, Closed]],

Cell["The characteristic vectors are:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(vecs\)], "Input"],

Cell[BoxData[
    \({{\(-1\), 0, \(-1\), 0, 1}, {0, \(-2\), 0, 1, 0}, {0, 1, \(-6\), 0, 
        2}, {0, \(-5\), 2, 2, 0}, {1, 0, 0, 0, 0}}\)], "Output"]
}, Closed]],

Cell["\<\
The characteristic roots with their associated characteristic \
vectors are:\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Transpose[{vals, vecs}] // MatrixForm\)], "Input"],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(-1\), \({\(-1\), 0, \(-1\), 0, 1}\)},
            {\(-1\), \({0, \(-2\), 0, 1, 0}\)},
            {"2", \({0, 1, \(-6\), 0, 2}\)},
            {"2", \({0, \(-5\), 2, 2, 0}\)},
            {"2", \({1, 0, 0, 0, 0}\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[
"Manual Solution of the characteristic value problem"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[BoxData[
    \(Clear[sys]\)], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The matrix a-r*I"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((sys[r_] = a - r\ IdentityMatrix[5])\) // MatrixForm\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(2 - r\), "6", "3", "12", "6"},
            {"0", \(26 - r\), "6", "54", "6"},
            {"0", "6", \(5 - r\), "12", "6"},
            {"0", \(-12\), \(-3\), \(\(-25\) - r\), \(-3\)},
            {"0", \(-6\), \(-3\), \(-12\), \(\(-4\) - r\)}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The characteristic polynomial"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(CharacteristicPoly[r_] = Factor[Det[sys[r]]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(\(-\((\(-2\) + r)\)\^3\)\ \((1 + r)\)\^2\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The characteristic roots"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[CharacteristicPoly[r] == 0]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{r \[Rule] \(-1\)}, {r \[Rule] \(-1\)}, {r \[Rule] 2}, {r \[Rule] 
          2}, {r \[Rule] 2}}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The distinct roots"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(Union[%]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{r \[Rule] \(-1\)}, {r \[Rule] 2}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \({r1, r2} = r /. %\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({\(-1\), 2}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The corresponding vectors"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(NullSpace[sys[r1]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{\(-1\), 0, \(-1\), 0, 1}, {0, \(-2\), 0, 1, 0}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(NullSpace[sys[r2]]\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \({{0, 1, \(-6\), 0, 2}, {0, \(-5\), 2, 2, 0}, {1, 0, 0, 0, 
        0}}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The solution vectors"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "This is an easy way to produce every vector solution in one step. It shows \
the vectors as rows, so we need to ",
  StyleBox["Transpose",
    FontWeight->"Bold"],
  " to obtain the actual columns which we use to check."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((Join[NullSpace[sys[r1]]\ Exp[r1\ x], 
          NullSpace[sys[r2]]\ Exp[r2\ x]])\) // MatrixForm\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(-\[ExponentialE]\^\(-x\)\), "0", \(-\[ExponentialE]\^\(-x\)\), 
              "0", \(\[ExponentialE]\^\(-x\)\)},
            {"0", \(\(-2\)\ \[ExponentialE]\^\(-x\)\), 
              "0", \(\[ExponentialE]\^\(-x\)\), "0"},
            {
              "0", \(\[ExponentialE]\^\(2\ x\)\), \(\(-6\)\ \[ExponentialE]\^\
\(2\ x\)\), "0", \(2\ \[ExponentialE]\^\(2\ x\)\)},
            {
              "0", \(\(-5\)\ \[ExponentialE]\^\(2\ x\)\), \(2\ \
\[ExponentialE]\^\(2\ x\)\), \(2\ \[ExponentialE]\^\(2\ x\)\), "0"},
            {\(\[ExponentialE]\^\(2\ x\)\), "0", "0", "0", "0"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["A fundamental solution matrix"], "Section",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    \(\((W[x_] = 
          Transpose[
            Join[NullSpace[sys[\(-1\)]]\ Exp[\(-x\)], 
              NullSpace[sys[2]]\ Exp[2\ x]]])\) // MatrixForm\)], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(-\[ExponentialE]\^\(-x\)\), "0", "0", 
              "0", \(\[ExponentialE]\^\(2\ x\)\)},
            {
              "0", \(\(-2\)\ \[ExponentialE]\^\(-x\)\), \
\(\[ExponentialE]\^\(2\ x\)\), \(\(-5\)\ \[ExponentialE]\^\(2\ x\)\), "0"},
            {\(-\[ExponentialE]\^\(-x\)\), 
              "0", \(\(-6\)\ \[ExponentialE]\^\(2\ x\)\), \(2\ \
\[ExponentialE]\^\(2\ x\)\), "0"},
            {"0", \(\[ExponentialE]\^\(-x\)\), 
              "0", \(2\ \[ExponentialE]\^\(2\ x\)\), "0"},
            {\(\[ExponentialE]\^\(-x\)\), 
              "0", \(2\ \[ExponentialE]\^\(2\ x\)\), "0", "0"}
            }], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Check."], "Subsubsection",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"Simplify", "[", 
      RowBox[{
        RowBox[{
          SuperscriptBox["W", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}], "==", \(a . W[x]\)}], 
      "]"}]], "Input",
  AspectRatioFixed->False],

Cell[BoxData[
    \(True\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Det[W[x]] \[NotEqual] 0\)], "Input"],

Cell[BoxData[
    \(2\ \[ExponentialE]\^\(4\ x\) \[NotEqual] 0\)], "Output"]
}, Closed]],

Cell["This is true.", "Text"]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{546, 528},
WindowMargins->{{12, Automatic}, {Automatic, 28}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 119, 3, 65, "Subtitle",
  Evaluatable->False],
Cell[1898, 58, 344, 8, 68, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2267, 70, 100, 2, 56, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2392, 76, 209, 4, 43, "Input"],
Cell[2604, 82, 177, 3, 43, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[2830, 91, 183, 6, 61, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3038, 101, 89, 2, 27, "Input"],
Cell[3130, 105, 193, 3, 43, "Output"]
}, Closed]],
Cell[3338, 111, 45, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[3408, 115, 37, 1, 27, "Input"],
Cell[3448, 118, 59, 1, 27, "Output"]
}, Closed]],
Cell[3522, 122, 47, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[3594, 126, 37, 1, 27, "Input"],
Cell[3634, 129, 153, 2, 43, "Output"]
}, Closed]],
Cell[3802, 134, 100, 3, 32, "Text"],

Cell[CellGroupData[{
Cell[3927, 141, 70, 1, 27, "Input"],
Cell[4000, 144, 410, 10, 101, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[4459, 160, 130, 3, 36, "Section",
  Evaluatable->False],
Cell[4592, 165, 43, 1, 27, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[4672, 171, 94, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[4791, 177, 114, 2, 27, "Input"],
Cell[4908, 181, 439, 10, 101, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[5396, 197, 107, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5528, 203, 104, 2, 27, "Input"],
Cell[5635, 207, 74, 1, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[5758, 214, 102, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[5885, 220, 93, 2, 27, "Input"],
Cell[5981, 224, 130, 2, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6160, 232, 96, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6281, 238, 68, 2, 27, "Input"],
Cell[6352, 242, 69, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[6458, 248, 77, 2, 27, "Input"],
Cell[6538, 252, 45, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[6632, 259, 103, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[6760, 265, 78, 2, 27, "Input"],
Cell[6841, 269, 83, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[6961, 275, 78, 2, 27, "Input"],
Cell[7042, 279, 104, 2, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7195, 287, 98, 2, 36, "Section",
  Evaluatable->False],
Cell[7296, 291, 300, 8, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7621, 303, 159, 3, 43, "Input"],
Cell[7783, 308, 775, 16, 111, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[8607, 330, 107, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8739, 336, 209, 5, 43, "Input"],
Cell[8951, 343, 790, 17, 115, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[9778, 365, 90, 2, 42, "Subsubsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9893, 371, 245, 7, 27, "Input"],
Cell[10141, 380, 38, 1, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[10216, 386, 56, 1, 27, "Input"],
Cell[10275, 389, 76, 1, 29, "Output"]
}, Closed]],
Cell[10366, 393, 29, 0, 32, "Text"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

